<?php

class Keyboards
{
    public static function main(): array
    {
        return ['keyboard' => [
            [['text' => 'لیست انتظار']]
        ], 'resize_keyboard' => true];
    }
    // delete or unpin
    public static function deleteOrUnpin(int $channelId, int $messageId): array
    {
        return ['inline_keyboard' => [
            [
                ['text' => 'حذف', 'callback_data' => "delete $channelId $messageId"],
                ['text' => 'حذف پین', 'callback_data' => "unpin $channelId $messageId"],
            ],
        ]];
    }
    public static function chooseTime(int $channelId, int $messageId, bool $unpin = false): array
    {
        $prefix = $unpin ? 'unpin' : 'delete';
        return ['inline_keyboard' => [
            [
                ['text' => '1 دقیقه', 'callback_data' => "$prefix $channelId $messageId 60"],
                ['text' => '5 دقیقه', 'callback_data' => "$prefix $channelId $messageId 300"],
                ['text' => '10 دقیقه', 'callback_data' => "$prefix $channelId $messageId 600"],
            ],
            [
                ['text' => '30 دقیقه', 'callback_data' => "$prefix $channelId $messageId 1800"],
                ['text' => '1 ساعت', 'callback_data' => "$prefix $channelId $messageId 3600"],
                ['text' => '2 ساعت', 'callback_data' => "$prefix $channelId $messageId 7200"],
            ],
            [
                ['text' => '3 ساعت', 'callback_data' => "$prefix $channelId $messageId 10800"],
                ['text' => '6 ساعت', 'callback_data' => "$prefix $channelId $messageId 21600"],
                ['text' => '12 ساعت', 'callback_data' => "$prefix $channelId $messageId 43200"],
            ],
            [
                ['text' => '24 ساعت', 'callback_data' => "$prefix $channelId $messageId 86400"],
                ['text' => '30 ساعت', 'callback_data' => "$prefix $channelId $messageId 108000"],
                ['text' => '48 ساعت', 'callback_data' => "$prefix $channelId $messageId 172800"],
            ],
        ]];
    }
}
