<?php

global $telegram, $database;
require_once __DIR__ . '/../TelegramInit.php';

$posts = $database->getPostsToUnpin();
foreach ($posts as $post) {
    $channelId = $post['ChannelId'];
    $channelMessageId = $post['MessageId'];
    $deleteTime = $post['UnpinTime'];
    $messageLink = "https://t.me/c/".str_replace('-100', '', $channelId)."/$channelMessageId";

    if ($deleteTime <= time()) {
        try {
            try {
                $telegram->unpinChatMessage($channelId, $channelMessageId);
            } catch (Throwable $e) {
                $errorMessage = $e->getMessage();
                $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, 'آنپین پیام ' . $messageLink . ' ناموفق بود: ' . $errorMessage);
            }
            $database->removePostToUnpin($channelId, $channelMessageId);
            $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, "پیام $messageLink آنپین شد");
        } catch (Throwable $e) {
            $errorMessage = $e->getMessage();
            $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, 'آنپین پیام ' . $messageLink . ' ناموفق بود: ' . $errorMessage);
        }
    }
}